#include <bits/stdc++.h>
using namespace std;

using ll = long long;

const int mxN = 3001;
vector<int> adj[mxN];
vector<int> visited(mxN);

void precomp() {
    for (int i = 0; i < mxN; i++) {
        visited[i] = false;
        adj[i].clear();
    }
}

void dfs(int u, int d, pair<int, int> &najdalje) {
    if (visited[u]) {
        return;
    }

    visited[u] = true;
    if (d > najdalje.second) {
        najdalje.first = u;
        najdalje.second = d;
    }

    for (int v : adj[u]) {
        if (!visited[v]) {
            dfs(v, d + 1, najdalje);
        }
    }
}

void solve() {
    int n, k;
    cin >> n >> k;

    for (int i = 0; i < n - 1; i++) {
        int u, v; cin >> u >> v;
        adj[u].push_back(v);
        adj[v].push_back(u);
    }

    pair<int, int> najdalje = {1, 0};
    dfs(1, 0, najdalje);

    int start = najdalje.first;
    for (int i = 1; i <= n; i++) visited[i] = false;
    dfs(start, 0, najdalje);

    int duz = najdalje.second;
    int edges_left = n - 1 - duz;
    int ans = min(duz + edges_left, duz + k);
    cout << ans << "\n";
}

int main()
{
    ios::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    int t; cin >> t;
    while(t--) {
        precomp();
        solve();
    }
    return 0;
}